/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc.bcast;

import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.fcs.impl.udp.NotificationQueue;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class DatagramPortOwner {
    protected static final String MULTICAST_ADDRESS = "225.4.5.6";
    private static final String TRACE_MASKD = "XFCSDPOD";
    private static final String TRACE_MASKF = "XFCSDPOF";
    private static final String TRACE_MASKT = "XFCSDPOT";
    private static DatagramPortOwner _singleton;
    private DatagramSocket outSocket;
    private DatagramSocket inSocket;
    private static boolean allowBroadcastOverPublicNetworks;
    private static NotificationQueue datagramQueue;
    private DatagramSocket[] outSockets;
    private static SocketListener[] socketListeners;
    private boolean useMultipleSockets = false;
    private boolean useMulticast = false;
    private static MachineId machineId;
    private boolean firstTry = true;

    public static synchronized DatagramPortOwner getDatagramPortOwner() {
        if (_singleton == null) {
            _singleton = new DatagramPortOwner();
        }
        return _singleton;
    }

    public void send(DatagramPacket packet) {
        block8: {
            block7: {
                if (!this.useMultipleSockets) break block7;
                if (this.outSockets == null) {
                    this.buildSocket();
                }
                if (this.outSockets == null) break block8;
                for (int i = 0; i < this.outSockets.length; ++i) {
                    if (this.outSockets[i] == null) continue;
                    try {
                        this.outSockets[i].send(packet);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                break block8;
            }
            if (this.outSocket == null) {
                this.buildSocket();
            }
            if (this.outSocket == null) break block8;
            try {
                this.outSocket.send(packet);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public DatagramPacket receive() {
        if (this.useMultipleSockets) {
            Object inPacket = null;
            if (socketListeners == null) {
                this.buildSocket();
            }
            if (socketListeners != null) {
                DatagramPacket fcsDatagram = (DatagramPacket)datagramQueue.readItem();
                return fcsDatagram;
            }
            return null;
        }
        DatagramPacket inPacket = null;
        if (this.inSocket == null) {
            this.buildSocket();
        }
        if (this.inSocket != null) {
            byte[] buffer = new byte[504];
            inPacket = new DatagramPacket(buffer, buffer.length);
            try {
                this.inSocket.receive(inPacket);
                FcsDatagram datagram = new FcsDatagram(inPacket);
            }
            catch (FcsException fcse) {
                inPacket = null;
            }
            catch (IOException ioe) {
                inPacket = null;
            }
            catch (Exception e) {
                inPacket = null;
            }
        }
        return inPacket;
    }

    public boolean socketBuildError() {
        if (this.useMultipleSockets) {
            return socketListeners == null && !this.firstTry;
        }
        return this.inSocket == null && !this.firstTry;
    }

    private DatagramPortOwner() {
        this.buildSocket();
        machineId = FcsServer.getFcsServer().getLocalMachineId();
        datagramQueue = new NotificationQueue();
        allowBroadcastOverPublicNetworks = FcsServer.getFcsServer().getConfigManager().isUsePublicBroadcast();
        this.useMulticast = FcsServer.getFcsServer().getConfigManager().isUseMulticast();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void buildSocket() {
        if (!this.firstTry) {
            return;
        }
        this.firstTry = false;
        if (this.useMultipleSockets) {
            try {
                if (this.outSockets == null && machineId != null) {
                    int i;
                    int count = 0;
                    for (i = 0; i < machineId.getNicAddresses().length; ++i) {
                        if (machineId.getPublicNetworkIndicators()[i] && !allowBroadcastOverPublicNetworks) continue;
                        ++count;
                    }
                    this.outSockets = new DatagramSocket[count];
                    count = 0;
                    for (i = 0; i < machineId.getNicAddresses().length; ++i) {
                        if (machineId.getPublicNetworkIndicators()[i] && !allowBroadcastOverPublicNetworks) continue;
                        if (this.useMulticast) {
                            this.outSockets[count] = new MulticastSocket();
                            ((MulticastSocket)this.outSockets[count]).setTimeToLive(5);
                            ((MulticastSocket)this.outSockets[count]).joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                            ((MulticastSocket)this.outSockets[count]).setInterface(machineId.getNicAddresses()[i]);
                        } else {
                            this.outSockets[count] = new DatagramSocket();
                            Trace.trace(TRACE_MASKF, "created new outSocket");
                        }
                        ++count;
                    }
                }
            }
            catch (SocketException se) {
                Trace.trace(TRACE_MASKF, se);
                this.outSockets = null;
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, ioe);
                this.outSockets = null;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                this.outSockets = null;
            }
            try {
                if (socketListeners != null) {
                    for (int i = 0; i < socketListeners.length; ++i) {
                        socketListeners[i].closeSocket();
                    }
                }
                if (machineId == null) return;
                socketListeners = new SocketListener[machineId.getNicAddresses().length];
                for (int i = 0; i < socketListeners.length; ++i) {
                    if (this.useMulticast) {
                        MulticastSocket tmpSocket = new MulticastSocket(9900);
                        tmpSocket.joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                        tmpSocket.setInterface(machineId.getNicAddresses()[i]);
                        DatagramPortOwner.socketListeners[i] = new SocketListener(tmpSocket, datagramQueue);
                    } else {
                        DatagramPortOwner.socketListeners[i] = new SocketListener(new DatagramSocket(9900), datagramQueue);
                    }
                    socketListeners[i].start();
                }
                return;
            }
            catch (SocketException se) {
                Trace.trace(TRACE_MASKF, se);
                socketListeners = null;
                return;
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, ioe);
                socketListeners = null;
                return;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                socketListeners = null;
                return;
            }
        }
        try {
            if (this.outSocket == null) {
                if (this.useMulticast) {
                    this.outSocket = new MulticastSocket();
                    ((MulticastSocket)this.outSocket).setTimeToLive(5);
                    ((MulticastSocket)this.outSocket).joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                    ((MulticastSocket)this.outSocket).setInterface(InetAddress.getLocalHost());
                } else {
                    this.outSocket = new DatagramSocket();
                }
            }
        }
        catch (SocketException se) {
            this.outSocket = null;
        }
        catch (IOException ioe) {
            this.outSocket = null;
        }
        try {
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.useMulticast) {
                this.inSocket = new MulticastSocket(9900);
                ((MulticastSocket)this.inSocket).joinGroup(InetAddress.getByName(MULTICAST_ADDRESS));
                ((MulticastSocket)this.inSocket).setInterface(InetAddress.getLocalHost());
                return;
            } else {
                this.inSocket = new DatagramSocket(9900);
            }
            return;
        }
        catch (SocketException se) {
            this.inSocket = null;
            return;
        }
        catch (IOException ioe) {
            this.inSocket = null;
        }
    }

    public void setUseMulticast(boolean value) {
        if (this.useMulticast != value) {
            this.useMulticast = value;
            this.closeSocket();
            this.buildSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSocket() {
        this.firstTry = true;
        if (this.useMultipleSockets) {
            int i;
            if (this.outSockets != null) {
                for (i = 0; i < this.outSockets.length; ++i) {
                    try {
                        this.outSockets[i].close();
                        continue;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Caught expected exc closing socket: " + e.getMessage());
                        continue;
                    }
                    finally {
                        this.outSockets[i] = null;
                    }
                }
                this.outSockets = null;
            }
            if (socketListeners != null) {
                for (i = 0; i < socketListeners.length; ++i) {
                    if (socketListeners[i] == null) continue;
                    try {
                        socketListeners[i].closeSocket();
                        continue;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Caught expected exc closing socket: " + e.getMessage());
                        continue;
                    }
                    finally {
                        DatagramPortOwner.socketListeners[i] = null;
                    }
                }
                socketListeners = null;
            }
        } else {
            if (this.outSocket != null) {
                try {
                    this.outSocket.close();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Caught expected exc closing socket: " + e.getMessage());
                }
                finally {
                    this.outSocket = null;
                }
            }
            if (this.inSocket != null) {
                try {
                    this.inSocket.close();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Caught expected exc closing socket: " + e.getMessage());
                }
                finally {
                    this.inSocket = null;
                }
            }
        }
    }

    public void restart() {
        if (this.useMultipleSockets) {
            if (this.outSockets == null || socketListeners == null) {
                this.buildSocket();
            }
        } else if (this.outSocket == null || this.inSocket == null) {
            this.buildSocket();
        }
    }

    public void networkSettingsChanged() {
        this.closeSocket();
        this.buildSocket();
        MachineId tmp = null;
        tmp = FcsServer.getFcsServer().getLocalMachineId();
        if (tmp != null) {
            machineId = tmp;
        }
    }

    public void setAllowBroadcastOverPublicNetworks(boolean newVal) {
        Trace.trace(TRACE_MASKF, "setAllowBroadcastOverPublicNetworks(" + newVal + ")");
        if (newVal != allowBroadcastOverPublicNetworks) {
            allowBroadcastOverPublicNetworks = newVal;
            this.closeSocket();
            this.buildSocket();
        }
    }

    static class SocketListener
    extends Thread {
        private static final String TRACE_MASKD = "XFCSDSLD";
        private static final String TRACE_MASKF = "XFCSDSLF";
        private static final String TRACE_MASKT = "XFCSDSLT";
        private DatagramSocket socket;
        private NotificationQueue datagramQueue;

        public SocketListener(DatagramSocket socket, NotificationQueue datagramQueue) {
            Trace.trace(TRACE_MASKF, "<> SocketListener");
            this.socket = socket;
            this.datagramQueue = datagramQueue;
        }

        public void closeSocket() {
            Trace.trace(TRACE_MASKF, "<> closeSocket()");
            try {
                this.socket.close();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Caught expected exc closing socket: " + e.getMessage());
            }
            this.socket = null;
        }

        public void run() {
            try {
                this.setName("FCS Datagram socket listener on: " + this.socket.toString());
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
            }
            while (this.socket != null) {
                byte[] buffer = new byte[504];
                DatagramPacket inPacket = new DatagramPacket(buffer, buffer.length);
                try {
                    this.socket.receive(inPacket);
                    FcsDatagram datagram = new FcsDatagram(inPacket);
                    this.datagramQueue.addItem(inPacket);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
    }
}

